* Output options - no page number, date, centering, or page breaks, 
  page length=MAX and width=120, eliminate SAS default titles and names of tables in output;
OPTIONS nonumber nodate nocenter formdlim='-' pagesize=MAX linesize=120; TITLE; ODS TRACE OFF;

* Income interaction example;

* Simulating data;
DATA example;
  	DO ID=1 TO 1000; 						* create ID variable and do for each subject;
	IF ID < 400 THEN MW=0; ELSE MW=1;		* assign sex to subject;
	intu = 	sqrt(1)*rannor(ID+6); 		    * random Int per person; 
	ed12 = ROUND((2)*rannor(ID+6),1); 		* person differences in edation;
	ed = ed12 + 12;							* original ed predictor;
		DO time=1 to 6;							* do for each time point;
		t1 = time-1;							* centered time;
	    resid = sqrt(.5)*rannor(time+ID+6); 	* level 1 residual;
			* calculating outcome;
			income =  50 + intu + resid + (4*t1) + (-.25*t1*t1) 
						+ (-10*MW) + (1*ed12) + (-.5*MW*ed12) 
					    + (.25*MW*t1) + (.10*MW*t1*t1) 
						+ (.50*ed12*t1) + (.05*MW*ed12*t1);
			output;		* write out line of data;
			end;		* end time loop;
		end;			* end person loop;
	drop intu resid; * removing loop indices and extra variables;
run;

* Creating other versions of predictors to get alternative simple effects;
DATA example; SET example;
	t6 = time-6;
	IF MW=0 THEN WM=1;
	IF MW=1 THEN WM=0;
	ed16 = ed-16;
RUN;


************************** Model 1 ***************************************;
TITLE "First Model: Fixed Quadratic Time, Time1=0 and Men=0 and Ed12=0";
PROC MIXED DATA=example COVTEST NOCLPRINT NOITPRINT METHOD=ML;
	CLASS ID;
	MODEL income = t1 t1*t1 MW ed12 MW*ed12 / SOLUTION DDFM=Satterthwaite; 
	RANDOM INTERCEPT / SUBJECT=ID TYPE=UN; 
* In ESTIMATE statements, first entry is the effect you are estimating (so first is always 1);
* Example of asking for predicted values at levels of predictors;
* Here, "t1" is actual time value;
ESTIMATE "Intercept at T1 for Men   Ed=12"	Int 1 t1 0 t1*t1 0  MW 0 ed12 0 MW*ed12 0;
ESTIMATE "Intercept at T1 for Men   Ed=16"	Int 1 t1 0 t1*t1 0  MW 0 ed12 4 MW*ed12 0;
ESTIMATE "Intercept at T1 for Women Ed=12"	Int 1 t1 0 t1*t1 0  MW 1 ed12 0 MW*ed12 0;
ESTIMATE "Intercept at T1 for Women Ed=16"	Int 1 t1 0 t1*t1 0  MW 1 ed12 4 MW*ed12 4;
ESTIMATE "Intercept at T6 for Men   Ed=12"	Int 1 t1 5 t1*t1 25 MW 0 ed12 0 MW*ed12 0;
ESTIMATE "Intercept at T6 for Men   Ed=16"	Int 1 t1 5 t1*t1 25 MW 0 ed12 4 MW*ed12 0;
ESTIMATE "Intercept at T6 for Women Ed=12"	Int 1 t1 5 t1*t1 25 MW 1 ed12 0 MW*ed12 0;
ESTIMATE "Intercept at T6 for Women Ed=16"	Int 1 t1 5 t1*t1 25 MW 1 ed12 4 MW*ed12 4;
* Example of asking for slopes at particular occasions;
* Here one of the "t1" = 1, the other t1=actual time;
ESTIMATE "Linear Slope (for anyone) at T1"	t1 1 t1*t1 0;
ESTIMATE "Linear Slope (for anyone) at T6"	t1 1 t1*t1 10; * Remember, quad*2;
* Example of asking for simple main effects of an interaction;
ESTIMATE "Sex Diff (at any time) if Ed=12"	MW 1   MW*ed12 0;
ESTIMATE "Sex Diff (at any time) if Ed=16"	MW 1   MW*ed12 4;
ESTIMATE "Ed Slope (at any time) for Men"	ed12 1 MW*ed12 0;
ESTIMATE "Ed Slope (at any time) for Women"	ed12 1 MW*ed12 1;
run;
* Can check estimates by re-centering predictors;
TITLE "First Model: Time6=0 and Women=0 and ed16=0 Instead";
PROC MIXED DATA=example COVTEST NOCLPRINT NOITPRINT METHOD=ML;
	CLASS ID;
	MODEL income = t6 t6*t6 WM ed16 WM*ed16 / SOLUTION DDFM=Satterthwaite; 
	RANDOM INTERCEPT / SUBJECT=ID TYPE=UN; 
run;


************************** Model 2 ***************************************;
TITLE "Second Model: Fixed Quadratic Time, Time1=0 and Men=0 and Ed12=0";
PROC MIXED DATA=example COVTEST NOCLPRINT NOITPRINT METHOD=ML;
	CLASS ID;
	MODEL income = t1 t1*t1 MW ed12 MW*ed12 
				   MW*t1 MW*t1*t1 ed12*t1 / SOLUTION DDFM=Satterthwaite; 
	RANDOM INTERCEPT / SUBJECT=ID TYPE=UN; 
* Example of asking for slopes at particular occasions for particular people;
* Here one of the "t1" = 1, the other t1=actual time;
ESTIMATE "Linear at T1 for Men   Ed=12"	t1 1 t1*t1 0  MW*t1 0 MW*t1*t1 0  ed12*t1 0;
ESTIMATE "Linear at T1 for Men   Ed=16"	t1 1 t1*t1 0  MW*t1 0 MW*t1*t1 0  ed12*t1 4;
ESTIMATE "Linear at T1 for Women Ed=12"	t1 1 t1*t1 0  MW*t1 1 MW*t1*t1 0  ed12*t1 0;
ESTIMATE "Linear at T1 for Women Ed=16"	t1 1 t1*t1 0  MW*t1 1 MW*t1*t1 0  ed12*t1 4;
ESTIMATE "Linear at T6 for Men   Ed=12"	t1 1 t1*t1 10 MW*t1 0 MW*t1*t1 0  ed12*t1 0;
ESTIMATE "Linear at T6 for Men   Ed=16"	t1 1 t1*t1 10 MW*t1 0 MW*t1*t1 0  ed12*t1 4;
ESTIMATE "Linear at T6 for Women Ed=12"	t1 1 t1*t1 10 MW*t1 1 MW*t1*t1 10 ed12*t1 0;
ESTIMATE "Linear at T6 for Women Ed=16"	t1 1 t1*t1 10 MW*t1 1 MW*t1*t1 10 ed12*t1 4;
* Example of asking for simple main effects of an interaction;
* Here, "t1" is actual time always;
ESTIMATE "Sex Diff at T1 if Ed=12"	MW 1 MW*t1 0 MW*t1*t1 0  MW*ed12 0;
ESTIMATE "Sex Diff at T1 if Ed=16"	MW 1 MW*t1 0 MW*t1*t1 0  MW*ed12 4;
ESTIMATE "Sex Diff at T6 if Ed=12"	MW 1 MW*t1 5 MW*t1*t1 25 MW*ed12 0;
ESTIMATE "Sex Diff at T6 if Ed=16"	MW 1 MW*t1 5 MW*t1*t1 25 MW*ed12 4;
ESTIMATE "Ed Slope at T1 for Men"	ed12 1 ed12*t1 0 MW*ed12 0;	
ESTIMATE "Ed Slope at T1 for Women"	ed12 1 ed12*t1 0 MW*ed12 1;
ESTIMATE "Ed Slope at T6 for Men"	ed12 1 ed12*t1 5 MW*ed12 0;
ESTIMATE "Ed Slope at T6 for Women"	ed12 1 ed12*t1 5 MW*ed12 1;
* Example of asking for simple two-way interactions of a three-way interaction;
ESTIMATE "Quadratic for Men"	t1*t1 1 MW*t1*t1 0;
ESTIMATE "Quadratic for Women"	t1*t1 1 MW*t1*t1 1;	
ESTIMATE "Sex by Time at T1"	MW*t1 1 MW*t1*t1 0;
ESTIMATE "Sex by Time at T6"	MW*t1 1 MW*t1*t1 10;
run;
TITLE "Second Model: Time6=0 and Women=0 and Ed16=0 Instead";
PROC MIXED DATA=example COVTEST NOCLPRINT NOITPRINT METHOD=ML;
	CLASS ID;
	MODEL income = t6 t6*t6 WM ed16 WM*ed16 
				   WM*t6 WM*t6*t6 ed16*t6 / SOLUTION DDFM=Satterthwaite; 
	RANDOM INTERCEPT / SUBJECT=ID TYPE=UN; 
run;
	

************************** Model 3 ***************************************;
TITLE "Third Model: Fixed Quadratic Time, Time1=0 and Men=0 and Ed12=0";
PROC MIXED DATA=example COVTEST NOCLPRINT NOITPRINT METHOD=ML;
	CLASS ID;
	MODEL income = t1 t1*t1 MW ed12 MW*ed12 MW*t1 MW*t1*t1 ed12*t1
				   MW*ed12*t1 / SOLUTION DDFM=Satterthwaite; 
	RANDOM INTERCEPT / SUBJECT=ID TYPE=UN;
* Example of asking for slopes at particular occasions for particular people;
* Here one of the "t1" = 1, the other t1=actual time;
ESTIMATE "Linear at T1 for Men Ed=12"	t1 1 t1*t1 0  MW*t1 0 MW*t1*t1 0  ed12*t1 0 MW*ed12*t1 0;
ESTIMATE "Linear at T1 for Men Ed=16"	t1 1 t1*t1 0  MW*t1 0 MW*t1*t1 0  ed12*t1 4 MW*ed12*t1 0;
ESTIMATE "Linear at T1 for Women Ed=12"	t1 1 t1*t1 0  MW*t1 1 MW*t1*t1 0  ed12*t1 0 MW*ed12*t1 0;
ESTIMATE "Linear at T1 for Women Ed=16"	t1 1 t1*t1 0  MW*t1 1 MW*t1*t1 0  ed12*t1 4 MW*ed12*t1 4;
ESTIMATE "Linear at T6 for Men Ed=12"	t1 1 t1*t1 10 MW*t1 0 MW*t1*t1 0  ed12*t1 0 MW*ed12*t1 0;
ESTIMATE "Linear at T6 for Men Ed=16"	t1 1 t1*t1 10 MW*t1 0 MW*t1*t1 0  ed12*t1 4 MW*ed12*t1 0;
ESTIMATE "Linear at T6 for Women Ed=12"	t1 1 t1*t1 10 MW*t1 1 MW*t1*t1 10 ed12*t1 0 MW*ed12*t1 0;
ESTIMATE "Linear at T6 for Women Ed=16"	t1 1 t1*t1 10 MW*t1 1 MW*t1*t1 10 ed12*t1 4 MW*ed12*t1 4;
* Example of asking for simple main effects of an interaction;
* Here, "t1" is actual time always;
ESTIMATE "Sex Diff at T1 if Ed=12"  MW 1 MW*ed12 0 MW*t1 0 MW*t1*t1 0  MW*ed12*t1 0;
ESTIMATE "Sex Diff at T1 if Ed=16"	MW 1 MW*ed12 4 MW*t1 0 MW*t1*t1 0  MW*ed12*t1 0;
ESTIMATE "Sex Diff at T6 if Ed=12"	MW 1 MW*ed12 0 MW*t1 5 MW*t1*t1 25 MW*ed12*t1 0;
ESTIMATE "Sex Diff at T6 if Ed=16"	MW 1 MW*ed12 4 MW*t1 5 MW*t1*t1 25 MW*ed12*t1 20;
ESTIMATE "Ed Slope at T1 for Men"	ed12 1 MW*ed12 0 ed12*t1 0  MW*ed12*t1 0;	
ESTIMATE "Ed Slope at T1 for Women"	ed12 1 MW*ed12 1 ed12*t1 0  MW*ed12*t1 0;
ESTIMATE "Ed Slope at T6 for Men"	ed12 1 MW*ed12 0 ed12*t1 5  MW*ed12*t1 0;
ESTIMATE "Ed Slope at T6 for Women"	ed12 1 MW*ed12 1 ed12*t1 5  MW*ed12*t1 5;	
* Example of asking for simple two-way interactions of a three-way interaction;
ESTIMATE "Quadratic for Men"				t1*t1 1 MW*t1*t1 0;
ESTIMATE "Quadratic for Women"				t1*t1 1 MW*t1*t1 1;	
ESTIMATE "Sex by Ed at T1"  				MW*ed12 1 MW*ed12*t1 0;
ESTIMATE "Sex by Ed at T6"  				MW*ed12 1 MW*ed12*t1 5;
ESTIMATE "Ed by Time for Men"				ed12*t1 1 MW*ed12*t1 0;
ESTIMATE "Ed by Time for Women"				ed12*t1 1 MW*ed12*t1 1;
ESTIMATE "Sex by Time (at T1) for Ed=12"	MW*t1  1 MW*ed12*t1 0 MW*t1*t1 0;
ESTIMATE "Sex by Time (at T1) for Ed=16"	MW*t1  1 MW*ed12*t1 4 MW*t1*t1 0;
ESTIMATE "Sex by Time (at T6) for Ed=12"	MW*t1  1 MW*ed12*t1 0 MW*t1*t1 10;
ESTIMATE "Sex by Time (at T6) for Ed=16"	MW*t1  1 MW*ed12*t1 4 MW*t1*t1 10;
run;
TITLE "Third Model: Time6=0 and Women=0 and Ed16=0 Instead";
PROC MIXED DATA=example COVTEST NOCLPRINT NOITPRINT METHOD=ML;
	CLASS ID;
	MODEL income = t6 t6*t6 WM ed16 WM*ed16 WM*t6 WM*t6*t6 ed16*t6 
				   WM*ed16*t6 / SOLUTION DDFM=Satterthwaite; 
	RANDOM INTERCEPT / SUBJECT=ID TYPE=UN;
run;
