* Generic session options - page and line size, no page breaks;
OPTIONS nonumber nodate nocenter pagesize=MAX linesize=120 formdlim=' ' spool;											
* Kill default titles on output, ODS tables in log; 
TITLE; ODS TRACE OFF;

* Location for original SAS files for these models  change this path;
%LET example = F:\Example Data\Chapter 6 Data\CHAP Burst 1 RT;
LIBNAME example "&example.";
* Defining macro variable for datafile name to be replaced in code below;
%LET datafile=Example7a;

* Bringing data into work library and recoding/centering variables;
* Centering time at different points for polynomial models;
DATA &datafile.; SET example.&datafile.; 
	* Centering time at session 1 or 6 for polynomial models;
	c1sess = session - 1; c6sess = session - 6;
	LABEL c1sess = "Session (0=1)" c6sess = "Session (0=6)";
	* Creating two slopes for piecewise models;
	     IF Session = 1 THEN DO; Slope12 = 0; Slope26 = 0; END;
	ELSE IF Session = 2 THEN DO; Slope12 = 1; Slope26 = 0; END;
	ELSE IF Session > 2 THEN DO; Slope12 = 1; Slope26 = Session-2; END;
	LABEL Slope12 = "1-2 Early Practice Slope"
	      Slope26 = "2-6 Later Practice Slope";
	* Centering level-2 predictors;
	Age80  = baseage - 80; 
	Reas22 = AbsReas - 22;			
	LABEL Age80  = "Age Centered (0=80)" 
	      Reas22 = "Abstract Reasoning Centered (0=22)"; 
	* Make education a grouping variable FOR DEMO PURPOSES;
		 IF EducYrs = . THEN EducGrp = .;
	ELSE IF EducYrs LE 12                   THEN EducGrp=1;
	ELSE IF EducYrs GT 12 AND EducYrs LE 16 THEN EducGrp=2;
	ELSE IF EducYrs GT 16                   THEN EducGrp=3;
	LABEL EducGrp= "Education Group (1=HS, 2=BA, 3=GRAD)";
RUN;

* REMOVING CASES WITH MISSING PREDICTORS OR OUTCOME;
DATA trimmed; SET &datafile.;
	WHERE NMISS(Age80, Reas22, EducGrp, session, nm3rt)=0; RUN;

* Changing dataset used in analyses below;
%LET datafile=trimmed;

*******************************************************************************************;
* To use TotalR2 macro:
PredFewer = name of dataset of predicted outcomes for nested model
NameFewer = label to use for nested model 
PredMore = 	name of dataset of predicted outcomes for comparison model
NameMore = 	label to use for comparison model;

%MACRO TotalR2(DV, PredFewer, NameFewer, PredMore, NameMore);
PROC CORR NOPRINT NOSIMPLE DATA=&PredFewer. OUTP=CorrFewer; VAR pred &DV.; RUN;
PROC CORR NOPRINT NOSIMPLE DATA=&PredMore.  OUTP=CorrMore;  VAR pred &DV.; RUN;
DATA CorrFewer; LENGTH Name $30.; SET CorrFewer; Name="&NameFewer."; RUN;
DATA CorrMore;  LENGTH Name $30.; SET CorrMore;  Name="&NameMore.";  RUN;
DATA CorrCompare; LENGTH Name $30.; SET CorrFewer CorrMore; 
	PredCorr=Pred; TotalR2=PredCorr*PredCorr; 
	IF _NAME_="Pred" OR MISSING(_NAME_)=1 THEN DELETE; DROP Pred; RUN;
DATA CorrCompare; SET CorrCompare; TotalR2Diff=TotalR2-LAG1(TotalR2);
	KEEP Name PredCorr TotalR2 TotalR2Diff; RUN; 
TITLE2 "Total R2 (% Reduction) for &NameFewer. vs. &NameMore.";
PROC PRINT NOOBS DATA=CorrCompare; RUN; TITLE2;	
%MEND TotalR2;

* To use PseudoR2 macro:
Ncov =		# entries in covariance parameters table
CovFewer = 	name of covparms table for nested model
NameFewer = label to use for nested model 
CovMore = 	name of covparms table for comparison model
NameMore = 	label to use for comparison model;

%MACRO PseudoR2(NCov, CovFewer, NameFewer, CovMore, NameMore);
DATA &CovFewer.; LENGTH Name $30.; SET &CovFewer.; Name="&NameFewer."; RUN;
DATA &CovMore.;  LENGTH Name $30.; SET &CovMore.;  Name="&NameMore.";  RUN;
DATA CovCompare; LENGTH Name $30.; SET &CovFewer. &CovMore.; RUN;
DATA CovCompare; SET CovCompare; 
	PseudoR2=(LAG&Ncov.(Estimate)-Estimate)/LAG&Ncov.(Estimate); RUN;
DATA CovCompare; SET CovCompare; 
	IF CovParm IN("UN(2,1)","UN(3,1)","UN(4,1)","UN(3,2)","UN(4,2)","UN(4,3)") 
	THEN DELETE; RUN;
TITLE2 "PsuedoR2 (% Reduction) for &NameFewer. vs. &NameMore.";
PROC PRINT NOOBS DATA=CovCompare; RUN; TITLE2;
%MEND PseudoR2;

* To use FitTest macro:
FitFewer = 	name of infocrit table for nested model
NameFewer = label to use for nested model 
FitMore = 	name of infocrit table for comparison model
NameMore = 	label to use for comparison model;

%MACRO FitTest(FitFewer, NameFewer, FitMore, NameMore);
DATA &FitFewer.; LENGTH Name $30.; SET &FitFewer.; Name="&NameFewer."; RUN;
DATA &FitMore.;  LENGTH Name $30.; SET &FitMore.;  Name="&NameMore.";  RUN;
DATA FitCompare; LENGTH Name $30.; SET &FitFewer. &FitMore.; RUN;
DATA FitCompare; SET FitCompare; DevDiff=Lag1(Neg2LogLike)-Neg2LogLike;
	DFdiff=Parms-LAG1(Parms); Pvalue=1-PROBCHI(DevDiff,DFdiff);
	DROP AICC HQIC CAIC; RUN;
TITLE2 "Likelihood Ratio Test for &NameFewer. vs. &NameMore.";
PROC PRINT NOOBS DATA=FitCompare; RUN; TITLE2;
%MEND FitTest;
*******************************************************************************************;


*** PIECEWISE GROWTH MODELS WITH PREDICTORS;

TITLE1 "Piecewise Unconditional Model - Random Early/Later Practice Slopes";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST IC NAMELEN=100 METHOD=ML;
	CLASS ID session;
	MODEL nm3rt = Slope12 Slope26 
				/ SOLUTION DDFM=Satterthwaite OUTPM=PredPiece; *Save time-predicted RT;;
	RANDOM INTERCEPT Slope12 Slope26 / TYPE=UN SUBJECT=ID; 
	REPEATED session / TYPE=VC SUBJECT=ID; 
	ODS OUTPUT CovParms=CovPiece InfoCrit=FitPiece; * Save covparms, fit for comparison;
RUN; 
PROC CORR DATA=PredPiece OUTP=CorrPiece; VAR pred nm3rt; RUN; * Correlation of predicted and actual RT; 

TITLE1 "Add Fixed Effects for Age on Intercept, Slope12, and Slope26";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST IC NAMELEN=100 METHOD=ML;
	CLASS ID session;
	MODEL nm3rt = Slope12 Slope26 Age80 Age80*Slope12 Age80*Slope26 
		/ SOLUTION DDFM=Satterthwaite OUTPM=PredAge; * Save fixed-predicted RT;
	RANDOM INTERCEPT Slope12 Slope26 / G TYPE=UN SUBJECT=ID; 
	REPEATED session / TYPE=VC SUBJECT=ID;
	ODS OUTPUT CovParms=CovAge InfoCrit=FitAge; * Save covparms, fit  for comparison;
	* Requesting slopes at age 80 and 90;
	ESTIMATE "Slope 1-2 for Age 80" Slope12 1 Age80*Slope12 0;
	ESTIMATE "Slope 1-2 for Age 90" Slope12 1 Age80*Slope12 10;
	ESTIMATE "Slope 2-6 for Age 80" Slope26 1 Age80*Slope26 0;
	ESTIMATE "Slope 2-6 for Age 90" Slope26 1 Age80*Slope26 10;
	* Requesting additional effects for age;
	ESTIMATE "Age Effect at Session 1" Age80 1 Age80*Slope12 0 Age80*Slope26 0;
	ESTIMATE "Age Effect at Session 2" Age80 1 Age80*Slope12 1 Age80*Slope26 0;
	ESTIMATE "Age Effect at Session 3" Age80 1 Age80*Slope12 1 Age80*Slope26 1;
	ESTIMATE "Age Effect at Session 4" Age80 1 Age80*Slope12 1 Age80*Slope26 2;
	ESTIMATE "Age Effect at Session 5" Age80 1 Age80*Slope12 1 Age80*Slope26 3;
	ESTIMATE "Age Effect at Session 6" Age80 1 Age80*Slope12 1 Age80*Slope26 4; 
RUN; PROC CORR DATA=PredAge; VAR pred nm3rt; RUN; * Correlation of predicted and actual RT;
* Calculate difference in model fit relative to unconditional model;
%FitTest(FitFewer=FitPiece, NameFewer=Unconditional, FitMore=FitAge, NameMore=Age);
* Calculate Total R2 change relative to unconditional model;
%TotalR2(DV=nm3rt, PredFewer=PredPiece, NameFewer=Unconditional, PredMore=PredAge, NameMore=Age);
* Calculate PseudoR2 relative to unconditional model;
%PseudoR2(NCov=7, CovFewer=CovPiece, NameFewer=Unconditional, CovMore=CovAge, NameMore=Age);

TITLE1 "Add Fixed Effects for Reasoning on Intercept, Slope12, and Slope26";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST NAMELEN=100 IC METHOD=ML;
	CLASS ID session;
	MODEL nm3rt = Slope12 Slope26 Age80 Age80*Slope12 Age80*Slope26
		          Reas22 Reas22*Slope12 Reas22*Slope26 
					/ SOLUTION DDFM=Satterthwaite OUTPM=PredReas; * Save fixed-predicted RT;
	RANDOM INTERCEPT Slope12 Slope26 / G TYPE=UN SUBJECT=ID; 
	REPEATED session / TYPE=VC SUBJECT=ID;
	ODS OUTPUT CovParms=CovReas InfoCrit=FitReas; * Save covparms, fit for comparison;
	* Requesting additional effects for reasoning;
	ESTIMATE "Reasoning Effect at Session 1" Reas22 1 Reas22*Slope12 0 Reas22*Slope26 0;
	ESTIMATE "Reasoning Effect at Session 2" Reas22 1 Reas22*Slope12 1 Reas22*Slope26 0;
	ESTIMATE "Reasoning Effect at Session 3" Reas22 1 Reas22*Slope12 1 Reas22*Slope26 1;
	ESTIMATE "Reasoning Effect at Session 4" Reas22 1 Reas22*Slope12 1 Reas22*Slope26 2;
	ESTIMATE "Reasoning Effect at Session 5" Reas22 1 Reas22*Slope12 1 Reas22*Slope26 3;
	ESTIMATE "Reasoning Effect at Session 6" Reas22 1 Reas22*Slope12 1 Reas22*Slope26 4; 
RUN;
* Calculate difference in model fit relative to age model;
%FitTest(FitFewer=FitAge, NameFewer=Age, FitMore=FitReas, NameMore=Reasoning);
* Calculate difference in model fit relative to unconditional model;
%FitTest(FitFewer=FitPiece, NameFewer=Unconditional, FitMore=FitReas, NameMore=Reasoning);
* Calculate Total R2 change relative to age model;
%TotalR2(DV=nm3rt, PredFewer=PredAge, NameFewer=Age, PredMore=PredReas, NameMore=Reasoning);
* Calculate PseudoR2 relative to age model;
%PseudoR2(NCov=7, CovFewer=CovAge, NameFewer=Age, CovMore=CovReas, NameMore=Reasoning);

TITLE1 "Add Effects of Education Group on Intercept, Slope12, and Slope26";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST IC NAMELEN=100 METHOD=ML;
	CLASS ID EducGrp session;
	MODEL nm3rt = Slope12 Slope26 Age80 Age80*Slope12 Age80*Slope26 
				  Reas22 Reas22*Slope12 Reas22*Slope26 
				  EducGrp Slope12*EducGrp Slope26*EducGrp 
					/ SOLUTION DDFM=Satterthwaite  OUTPM=PredEdPiece; * Save fixed-predicted RT;
	RANDOM INTERCEPT Slope12 Slope26 / G TYPE=UN SUBJECT=ID; 
	REPEATED session / TYPE=VC SUBJECT=ID;
	ODS OUTPUT CovParms=CovEdPiece InfoCrit=FitEdPiece; * Save covparms, fit for comparison;
	* LSMEANS gives follow-up tests and means per group for education main effect only;
	LSMEANS EducGrp  / AT (Slope12 Slope26 Age80 Reas22) = (0 0 0 0) DIFF=ALL; 
	LSMEANS EducGrp  / AT (Slope12 Slope26 Age80 Reas22) = (1 4 0 0) DIFF=ALL; 
	* ESTIMATE statements can also give specific effects as before;
	ESTIMATE "L vs. H Educ for Intercept "  EducGrp -1  0  1 ;
	ESTIMATE "M vs. H Educ for Intercept"  	EducGrp  0 -1  1 ;
	ESTIMATE "L vs. M Educ for Intercept"  	EducGrp -1  1  0 ;
	ESTIMATE "L vs. H Educ for Slope12"  	Slope12*EducGrp -1  0  1 ;
	ESTIMATE "M vs. H Educ for Slope12"  	Slope12*EducGrp  0 -1  1 ;
	ESTIMATE "L vs. M Educ for Slope12"  	Slope12*EducGrp -1  1  0 ;
	ESTIMATE "L vs. H Educ for Slope26"  	Slope26*EducGrp -1  0  1 ;	
	ESTIMATE "M vs. H Educ for Slope26"  	Slope26*EducGrp  0 -1  1 ;
	ESTIMATE "L vs. M Educ for Slope26"  	Slope26*EducGrp -1  1  0 ;
RUN;
* Calculate difference in model fit relative to  model with age and reasoning;
%FitTest(FitFewer=FitReas, NameFewer=Reasoning, FitMore=FitEdPiece, NameMore=EducGrp);
* Calculate Total R2 change relative to model with age and reasoning;
%TotalR2(DV=nm3rt, PredFewer=PredReas, NameFewer=Reasoning, PredMore=PredEdPiece, NameMore=EducGrp);
* Calculate PseudoR2 relative to model with age and reasoning;
%PseudoR2(NCov=7, CovFewer=CovReas, NameFewer=Reasoning, CovMore=CovEdPiece, NameMore=EducGrp);

TITLE1 "Add Fixed Effects for Age*Reasoning on Intercept, Slope12, and Slope26";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST NAMELEN=100 IC METHOD=ML;
	CLASS ID session;
	MODEL nm3rt = Slope12 Slope26 Age80 Age80*Slope12 Age80*Slope26
		          Reas22 Reas22*Slope12 Reas22*Slope26 
				  Age80*Reas22 Age80*Reas22*Slope12 Age80*Reas22*Slope26
					/ SOLUTION DDFM=Satterthwaite OUTPM=PredAgeReas; * Save fixed-predicted RT;
	RANDOM INTERCEPT Slope12 Slope26 / G TYPE=UN SUBJECT=ID; 
	REPEATED session / TYPE=VC SUBJECT=ID;
	ODS OUTPUT CovParms=CovAgeReas InfoCrit=FitAgeReas; * Save covparms, fit for comparison;
* Age simple effects to decompose interactions;
ESTIMATE "Age Effect on Intercept, Reas 17"  Age80 1 Reas22*Age80 -5;
ESTIMATE "Age Effect on Intercept, Reas 22"  Age80 1 Reas22*Age80  0;
ESTIMATE "Age Effect on Intercept, Reas 27"  Age80 1 Reas22*Age80  5;
ESTIMATE "Age Effect on Slope12,   Reas 17"  Age80*Slope12 1 Reas22*Age80*Slope12 -5;
ESTIMATE "Age Effect on Slope12,   Reas 22"  Age80*Slope12 1 Reas22*Age80*Slope12  0;
ESTIMATE "Age Effect on Slope12,   Reas 27"  Age80*Slope12 1 Reas22*Age80*Slope12  5;
ESTIMATE "Age Effect on Slope26,   Reas 17"  Age80*Slope26 1 Reas22*Age80*Slope26 -5;
ESTIMATE "Age Effect on Slope26,   Reas 22"  Age80*Slope26 1 Reas22*Age80*Slope26  0;
ESTIMATE "Age Effect on Slope26,   Reas 27"  Age80*Slope26 1 Reas22*Age80*Slope26  5;
* Reasoning simple effects to decompose interactions;
ESTIMATE "Reasoning Effect on Intercept, Age 70"  Reas22 1 Reas22*Age80 -10;
ESTIMATE "Reasoning Effect on Intercept, Age 80"  Reas22 1 Reas22*Age80   0;
ESTIMATE "Reasoning Effect on Intercept, Age 90"  Reas22 1 Reas22*Age80  10;
ESTIMATE "Reasoning Effect on Slope12,   Age 70"  Reas22*Slope12 1 Reas22*Age80*Slope12 -10;
ESTIMATE "Reasoning Effect on Slope12,   Age 80"  Reas22*Slope12 1 Reas22*Age80*Slope12   0;
ESTIMATE "Reasoning Effect on Slope12,   Age 90"  Reas22*Slope12 1 Reas22*Age80*Slope12  10;
ESTIMATE "Reasoning Effect on Slope26,   Age 70"  Reas22*Slope26 1 Reas22*Age80*Slope26 -10;
ESTIMATE "Reasoning Effect on Slope26,   Age 80"  Reas22*Slope26 1 Reas22*Age80*Slope26   0;
ESTIMATE "Reasoning Effect on Slope26,   Age 90"  Reas22*Slope26 1 Reas22*Age80*Slope26  10;
RUN;
* Calculate difference in model fit relative to age and reasoning main effects model;
%FitTest(FitFewer=FitReas, NameFewer=Age+Reasoning, FitMore=FitAgeReas, NameMore=Age*Reasoning);
* Calculate Total R2 change relative to age and reasoning main effects model;
%TotalR2(DV=nm3rt, PredFewer=PredReas, NameFewer=Age+Reasoning, PredMore=PredAgeReas, NameMore=Age*Reasoning);
* Calculate PseudoR2 relative to age and reasoning main effects model;
%PseudoR2(NCov=7, CovFewer=CovReas, NameFewer=Age+Reasoning, CovMore=CovAgeReas, NameMore=Age*Reasoning);


*** POLYNOMIAL GROWTH MODELS WITH PREDICTORS;

TITLE1 "Age + Reasoning on Intercept, Linear, and Quadratic Time Slopes";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST IC NAMELEN=100 METHOD=ML;
	CLASS ID session;
	MODEL nm3rt = c1sess c1sess*c1sess Age80 c1sess*Age80 c1sess*c1sess*Age80
			  	  Reas22 c1sess*Reas22 c1sess*c1sess*Reas22 
					/ SOLUTION DDFM=Satterthwaite OUTPM=PredARQuad; * Save fixed-predicted RT;
	RANDOM INTERCEPT c1sess c1sess*c1sess / G TYPE=UN SUBJECT=ID;
	REPEATED session / TYPE=VC SUBJECT=ID; 
	ODS OUTPUT CovParms=CovARQuad InfoCrit=FitARQuad; * Save covparms, fit for comparison;
* Requesting additional effects for age;
ESTIMATE "Age Effect at Session 1" Age80 1 c1sess*Age80 0 c1sess*c1sess*Age80 0;
ESTIMATE "Age Effect at Session 2" Age80 1 c1sess*Age80 1 c1sess*c1sess*Age80 1;
ESTIMATE "Age Effect at Session 3" Age80 1 c1sess*Age80 2 c1sess*c1sess*Age80 4;
ESTIMATE "Age Effect at Session 4" Age80 1 c1sess*Age80 3 c1sess*c1sess*Age80 9;
ESTIMATE "Age Effect at Session 5" Age80 1 c1sess*Age80 4 c1sess*c1sess*Age80 16;
ESTIMATE "Age Effect at Session 6" Age80 1 c1sess*Age80 5 c1sess*c1sess*Age80 25;
ESTIMATE "Age*Linear Time Slope at Session 1" c1sess*Age80 1 c1sess*c1sess*Age80 0;
ESTIMATE "Age*Linear Time Slope at Session 2" c1sess*Age80 1 c1sess*c1sess*Age80 2;
ESTIMATE "Age*Linear Time Slope at Session 3" c1sess*Age80 1 c1sess*c1sess*Age80 4;
ESTIMATE "Age*Linear Time Slope at Session 4" c1sess*Age80 1 c1sess*c1sess*Age80 6;
ESTIMATE "Age*Linear Time Slope at Session 5" c1sess*Age80 1 c1sess*c1sess*Age80 8;
ESTIMATE "Age*Linear Time Slope at Session 6" c1sess*Age80 1 c1sess*c1sess*Age80 10;
* Requesting additional effects for reasoning; 
ESTIMATE "Reasoning Effect at Session 1" Reas22 1 c1sess*Reas22 0 c1sess*c1sess*Reas22 0;
ESTIMATE "Reasoning Effect at Session 2" Reas22 1 c1sess*Reas22 1 c1sess*c1sess*Reas22 1;
ESTIMATE "Reasoning Effect at Session 3" Reas22 1 c1sess*Reas22 2 c1sess*c1sess*Reas22 4;
ESTIMATE "Reasoning Effect at Session 4" Reas22 1 c1sess*Reas22 3 c1sess*c1sess*Reas22 9;
ESTIMATE "Reasoning Effect at Session 5" Reas22 1 c1sess*Reas22 4 c1sess*c1sess*Reas22 16;
ESTIMATE "Reasoning Effect at Session 6" Reas22 1 c1sess*Reas22 5 c1sess*c1sess*Reas22 25;
ESTIMATE "Reasoning*Linear Time Slope at Session 1" c1sess*Reas22 1 c1sess*c1sess*Reas22 0;
ESTIMATE "Reasoning*Linear Time Slope at Session 2" c1sess*Reas22 1 c1sess*c1sess*Reas22 2;
ESTIMATE "Reasoning*Linear Time Slope at Session 3" c1sess*Reas22 1 c1sess*c1sess*Reas22 4;
ESTIMATE "Reasoning*Linear Time Slope at Session 4" c1sess*Reas22 1 c1sess*c1sess*Reas22 6;
ESTIMATE "Reasoning*Linear Time Slope at Session 5" c1sess*Reas22 1 c1sess*c1sess*Reas22 8;
ESTIMATE "Reasoning*Linear Time Slope at Session 6" c1sess*Reas22 1 c1sess*c1sess*Reas22 10;
RUN;

/* Check against session 6;
TITLE1 "Age + Reasoning on Intercept, Linear, and Quadratic Time Slopes";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST IC NAMELEN=100 METHOD=ML;
	CLASS ID session;
	MODEL nm3rt = c6sess c6sess*c6sess Age80 c6sess*Age80 c6sess*c6sess*Age80
			  	  Reas22 c6sess*Reas22 c6sess*c6sess*Reas22 
					/ SOLUTION DDFM=Satterthwaite OUTPM=PredQ; * Save fixed-predicted RT;
	RANDOM INTERCEPT c6sess c6sess*c6sess / G TYPE=UN SUBJECT=ID;
	REPEATED session / TYPE=VC SUBJECT=ID; 
RUN; */

TITLE1 "Remove Reasoning Effect on Quadratic Time Slope";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST IC NAMELEN=100 METHOD=ML;
	CLASS ID session;
	MODEL nm3rt = c1sess c1sess*c1sess Age80 c1sess*Age80 c1sess*c1sess*Age80
			  	  Reas22 c1sess*Reas22  / SOLUTION DDFM=Satterthwaite OUTPM=PredARLin; * Save fixed-predicted RT;
	RANDOM INTERCEPT c1sess c1sess*c1sess / G TYPE=UN SUBJECT=ID; 
	REPEATED session / TYPE=VC SUBJECT=ID;
	ODS OUTPUT CovParms=CovARLin InfoCrit=FitARQLin; * Save covparms, fit for comparison;
* Requesting additional effects for age;
ESTIMATE "Age Effect at Session 1" Age80 1 c1sess*Age80 0 c1sess*c1sess*Age80 0;
ESTIMATE "Age Effect at Session 2" Age80 1 c1sess*Age80 1 c1sess*c1sess*Age80 1;
ESTIMATE "Age Effect at Session 3" Age80 1 c1sess*Age80 2 c1sess*c1sess*Age80 4;
ESTIMATE "Age Effect at Session 4" Age80 1 c1sess*Age80 3 c1sess*c1sess*Age80 9;
ESTIMATE "Age Effect at Session 5" Age80 1 c1sess*Age80 4 c1sess*c1sess*Age80 16;
ESTIMATE "Age Effect at Session 6" Age80 1 c1sess*Age80 5 c1sess*c1sess*Age80 25;
ESTIMATE "Age*Linear Time Slope at Session 1" c1sess*Age80 1 c1sess*c1sess*Age80 0;
ESTIMATE "Age*Linear Time Slope at Session 2" c1sess*Age80 1 c1sess*c1sess*Age80 2;
ESTIMATE "Age*Linear Time Slope at Session 3" c1sess*Age80 1 c1sess*c1sess*Age80 4;
ESTIMATE "Age*Linear Time Slope at Session 4" c1sess*Age80 1 c1sess*c1sess*Age80 6;
ESTIMATE "Age*Linear Time Slope at Session 5" c1sess*Age80 1 c1sess*c1sess*Age80 8;
ESTIMATE "Age*Linear Time Slope at Session 6" c1sess*Age80 1 c1sess*c1sess*Age80 10;
* Requesting additional effects for reasoning; 
ESTIMATE "Reasoning Effect at Session 1" Reas22 1 c1sess*Reas22 0;
ESTIMATE "Reasoning Effect at Session 2" Reas22 1 c1sess*Reas22 1;
ESTIMATE "Reasoning Effect at Session 3" Reas22 1 c1sess*Reas22 2;
ESTIMATE "Reasoning Effect at Session 4" Reas22 1 c1sess*Reas22 3;
ESTIMATE "Reasoning Effect at Session 5" Reas22 1 c1sess*Reas22 4;
ESTIMATE "Reasoning Effect at Session 6" Reas22 1 c1sess*Reas22 5;
RUN;
* Calculate difference in model fit relative to model with reasoning*quad;
%FitTest(FitFewer=FitARQLin, NameFewer=NOReasoning*Quad, FitMore=FitARQuad, NameMore=YESReasoning*Quad);

TITLE1 "Add Effect of Education Group on Intercept, Linear, and Quadratic";
PROC MIXED DATA=&datafile. NOCLPRINT COVTEST IC NAMELEN=100 METHOD=ML;
	CLASS ID EducGrp session;
	MODEL nm3rt = c1sess c1sess*c1sess Age80 c1sess*Age80 c1sess*c1sess*Age80
				  Reas22 c1sess*Reas22 EducGrp c1sess*EducGrp c1sess*c1sess*EducGrp 
					/ SOLUTION DDFM=Satterthwaite  OUTPM=PredEdQuad; * Save fixed-predicted RT;
	RANDOM INTERCEPT c1sess c1sess*c1sess / G TYPE=UN SUBJECT=ID; 
	REPEATED session / TYPE=VC SUBJECT=ID;
	ODS OUTPUT CovParms=CovEdQuad InfoCrit=FitEdQuad; * Save covparms, fit for comparison;
	* LSMEANS gives follow-up tests and means per group for education main effect only;
	LSMEANS EducGrp  / AT (c1sess Age80 Reas22) = (0 0 0) DIFF=ALL; 
	LSMEANS EducGrp  / AT (c1sess Age80 Reas22) = (5 0 0) DIFF=ALL; 
	* ESTIMATE statements can also give specific effects as before;
	ESTIMATE "L vs. H Educ for Intercept "  	EducGrp -1  0  1 ;
	ESTIMATE "M vs. H Educ for Intercept"  		EducGrp  0 -1  1 ;
	ESTIMATE "L vs. M Educ for Intercept"  		EducGrp -1  1  0 ;
	ESTIMATE "L vs. H Educ for Linear Time"  	c1sess*EducGrp -1  0  1 ;
	ESTIMATE "M vs. H Educ for Linear Time"  	c1sess*EducGrp  0 -1  1 ;
	ESTIMATE "L vs. M Educ for Linear Time"  	c1sess*EducGrp -1  1  0 ;
	ESTIMATE "L vs. H Educ for Quadratic Time"  c1sess*c1sess*EducGrp -1  0  1 ;	
	ESTIMATE "M vs. H Educ for Quadratic Time"  c1sess*c1sess*EducGrp  0 -1  1 ;
	ESTIMATE "L vs. M Educ for Quadratic Time"  c1sess*c1sess*EducGrp -1  1  0 ;
RUN;
* Calculate difference in model fit relative to model with reasoning*linear only;
%FitTest(FitFewer=FitARQLin, NameFewer=NOReasoning*Quad, FitMore=FitEdQuad, NameMore=EducGrp);
* Calculate Total R2 change relative to model with reasoning*linear only;
%TotalR2(DV=nm3rt, PredFewer=PredARLin, NameFewer=NOReasoning*Quad, PredMore=PredEdQuad, NameMore=EducGrp);
* Calculate PseudoR2 relative to model with reasoning*linear only;
%PseudoR2(NCov=7, CovFewer=CovARLin, NameFewer=NOReasoning*Quad, CovMore=CovEdQuad, NameMore=EducGrp);
