*GENERATING DATA FROM UNIVARIATE NORMAL WITH MEAN 100 AND SD 15:;

%LET samplesize = 50;
%LET b0 = 100;
%LET errorvar = 225;
%LET randomseed = 10252012; 

DATA work.normalgen;
	CALL STREAMINIT(&randomseed.); *SET RANDOM SEED VALUE;
	DO i=1 TO &samplesize.;
		id = i;
		y = &b0. + RAND("NORMAL",0,SQRT(&errorvar.));
		OUTPUT;
	END;	
	DROP i;
RUN;

PROC MIXED DATA=WORK.normalgen METHOD=ML;
MODEL y=/SOLUTION;
RUN;

*INITIAL PROC MCMC RUN: PRIORS FROM SLIDE 13 - but without burnin period;
PROC MCMC DATA=work.normalgen OUTPOST=work.outpost SEED=10252012 
		  NBI=0 THIN=1 NMC=10000 DIC;
	PARMS b0, errorvar;
	PRIOR b0 ~ N(100,SD=2.13);
	PRIOR errorvar ~ UNIFORM(200,400);
	
	condmean_y = b0;
	MODEL y ~ N(condmean_y,VAR=errorvar);
RUN;


PROC MCMC DATA=work.normalgen OUTPOST=work.outpost SEED=10252012 
		  NBI=2500 THIN=25 NMC=10000 DIC;
	PARMS b0, errorvar;
	PRIOR b0 ~ N(100,SD=2.13);
	PRIOR errorvar ~ UNIFORM(200,400);
	
	condmean_y = b0;
	MODEL y ~ N(condmean_y,VAR=errorvar);
RUN;


PROC MCMC DATA=work.normalgen OUTPOST=work.outpost SEED=10252012 
	NBI=1000 THIN=25 NMC=10000 DIC;
	PARMS b0, errorvar;
	PRIOR b0 ~ NORMAL(0,var=1e6);
	PRIOR errorvar ~ igamma(shape = 3/10, scale = 10/3);
	
	condmean_y = b0;
	MODEL y ~ N(condmean_y,VAR=errorvar);

RUN;


PROC MCMC DATA=work.normalgen OUTPOST=work.outpost SEED=10252012 
		  NBI=2500 THIN=25 NMC=10000 DIC;
	PARMS b0, errorvar;
	PRIOR b0 ~ UNIFORM(102,103);
	PRIOR errorvar ~ UNIFORM(238,242);
	
	condmean_y = b0;
	MODEL y ~ N(condmean_y,VAR=errorvar);
RUN;
