* Generic session options - page and line size, no page breaks;
OPTIONS nonumber nodate nocenter pagesize=MAX linesize=120 formdlim=' ';											
* Kill default titles on output; 
TITLE;

* Define folder where plots will go;
%LET filesave= C:\Dropbox\21_PSQF7375_Longitudinal\PSQF7375_Longitudinal_Polynomial_Simulation;

* Kind of model you are simulating;
%LET modeltype= Random Quadratic;
%LET modelnotes= Positive Fixed Linear, Negative Fixed Quadratic;

* Place variances of random effects here;
DATA Gmatrix; INPUT IntU0 LinU1 QuadU2; CARDS;
10.0   0.0   0.0
 0.0   3.0   0.0 
 0.0   0.0   0.10
; run;

* Place fixed effects here (one per line);
DATA FixedEffects; INPUT fixed; CARDS;
10
3
-.3
; run;

* Multivariate normal data generator;
%MACRO mvn(version,
           varcov=,       /* dataset for variance-covariance matrix */
           means=,        /* dataset for mean vector */
           n=,            /* sample size */
           seed=0,        /* seed for random number generator */
           sample=);      /* output dataset name */
%IF &version ne %THEN %PUT MVN macro Version 1.0;
 /* Get initial seed value.  If seed<=0, then generate seed from the
    system clock. */
data _null_;
   if &seed le 0 then do;
      seed = int(time());   /* get clock time in integer seconds */
      put seed=;
      call symput('seed',seed);   /* store seed as macro variable */
   end; run;
 /* Generate the multivariate normal data in SAS/IML */
proc iml worksize=100;
   use &varcov;            /* read variance-covariance matrix */
   read all into cov;
   use &means;             /* read means */
   read all into mu;
   v=nrow(cov);            /* calculate number of variables */
   n=&n;
   seed = &seed;
   l=t(root(cov));         /* calculate cholesky root of cov matrix */
   z=normal(j(v,&n,&seed));/* generate nvars*samplesize normals */
   x=l*z;                  /* premultiply by cholesky root */
   x=repeat(mu,1,&n)+x;    /* add in the means */
   tx=t(x);
   create &sample from tx;  /* write out sample data to sas dataset */
   append from tx;
quit;
%MEND mvn;


* Draw a random sample of 500 given parameters above;
%mvn(varcov=Gmatrix,means=FixedEffects,n=500,sample=RandEffects)

* Build values of Y given fixed and random effects (no error here);
DATA SimPeople (drop=col1 col2 col3); SET RandEffects;
	IDnum = _N_;	* Adding subject ID numbers;
	RandInt=col1; RandLin=col2; RandQuad=col3; * Renaming for my sanity;
	DO time=-5 to 5; * 11 time points;
		e = SQRT(1)*RANNOR(0);	* add e resid;
		y= RandInt + RandLin*time + RandQuad*time*time + e; 
			OUTPUT; * Generate Y for each observation;
	END;
run;

* Check actual parameters in simulated data;
TITLE1 JUSTIFY=CENTER HEIGHT=14pt "&modeltype.";
TITLE2 JUSTIFY=CENTER HEIGHT=12pt "&modelnotes.";
PROC MIXED DATA=SimPeople COVTEST NOITPRINT NOCLPRINT NOINFO METHOD=REML;
	CLASS IDnum;
	MODEL y= time time*time / SOLUTION DDFM=Satterthwaite NOTEST;
	RANDOM INTERCEPT time time*time / G TYPE=UN SUBJECT=IDnum;
run;

* Setting system options for graphics below;
GOPTIONS RESET=ALL NOBORDER FTEXT="Arial" FTITLE="Arial" VSIZE=8.0in HSIZE=8.0in INTERPOL=JOIN;

* Open output directory to save results to;
ODS RTF FILE="&filesave.\&modeltype. &modelnotes..rtf" STYLE=HTMLBlue STARTPAGE=NO;

* Generating plot for INDIVIDUALS and MEAN, saving it to location above;
TITLE1 JUSTIFY=CENTER HEIGHT=14pt "&modeltype. Trajectories";
TITLE2 JUSTIFY=CENTER HEIGHT=12pt "&modelnotes.";
PROC GPLOT DATA=SimPeople UNIFORM; WHERE IDnum <=25;
* Settings for Y-axis;
  AXIS1 LENGTH=6.0in LABEL=(ANGLE=90 HEIGHT=12pt "Simulated Y");
* Settings for X-axis;
  AXIS2 LENGTH=7.0in LABEL=(HEIGHT=12pt "Time in Study") ORDER=(-5 TO 5 BY 1);
 * Specification for all other lines (from REPEAT option);
 SYMBOL1 VALUE=NONE LINE=1 WIDTH=1 REPEAT=1000;
 * Plot Y*X=separate person, start axes at 0 unless otherwise specified;
 PLOT Y*time=IDnum / VZERO HZERO NOLEGEND VAXIS=AXIS1 HAXIS=AXIS2;  
RUN; QUIT;
* Need to reset goptions to kill symbol specifications;
GOPTIONS RESET=ALL; RUN;

* Close file figures are saved to;
ODS RTF CLOSE; 






